#include <yandex/maps/wiki/validator/objects/arrival_point.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

ArrivalPoint::ArrivalPoint(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , parentId_(
        extractRelation(
            masters, ASSIGNED_ROLE, IsMandatory::Yes,
            MESSAGE_BAD_PARENT_RELATION, id))
    , names_(extractNameRelations(slaves))
    , isMajor_(
        extractAttrBySuffix<bool>(
            attributes, IS_MAJOR_ATTR_SUFFIX, IsMandatory::No,
            "bad-is_major-attribute", id))
    , dropoffPickup_(
        extractAttrBySuffix<bool>(
            attributes, DROPOFF_PICKUP_ATTR_SUFFIX, IsMandatory::No,
            "bad-dropoff_pickup-attribute", id))
{ }

} // namespace maps::wiki::validator
