#include <yandex/maps/wiki/validator/objects/building.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

Building::Building(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& /* masters */,
        const Relations& /* slaves */)
    : id_(id)
    , featureType_(extractFeatureType(attributes, id))
    , geom_(std::move(geom))
    , height_(extractAttr<std::string>(
        attributes, BLD_HEIGHT_ATTR, IsMandatory::No, {}, id))
{ }

} // namespace maps::wiki::validator
