#include <yandex/maps/wiki/validator/objects/center.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

Center::Center(
        TId id,
        TGeom geom,
        const AttrMap& /* attributes */,
        const Relations& masters,
        const Relations& /* slaves */)
    : id_(id)
    , parent_(
            extractRelation(
                    masters, CENTER_ROLE, IsMandatory::Yes, MESSAGE_BAD_PARENT_RELATION, id))
    , geom_(std::move(geom))
{ }

} // namespace maps:;wiki::validator
