#include <yandex/maps/wiki/validator/objects/cond_annotation.h>
#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

#include <maps/libs/common/include/exception.h>

#include <algorithm>

namespace maps::wiki::validator {

CondAnnotation::CondAnnotation(
            TId id,
            const AttrMap& attributes,
            const Relations& /* masters */,
            const Relations& slaves)
        : id_(id)
        , annotationId_(
                extractAttr<int>(
                        attributes, ANNOTATION_ID_ATTR_NAME, IsMandatory::Yes,
                        "bad-annotation-id", id))
        , viaJunction_(
                extractRelation(
                        slaves, VIA_JUNCTION_ROLE, IsMandatory::Yes,
                        "bad-via-junction-relation", id))
        , fromRoadElement_(
                extractRelation(
                        slaves, FROM_RD_EL_ROLE, IsMandatory::Yes,
                        "bad-from-element-relation", id))
{
    for (const auto& relation : slaves) {
        if (relation.role == TO_RD_EL_ROLE) {
            if (!relation.seqNum) {
                throw InvalidRelationsException(
                    "bad-cond-relation", id,
                    {relation.other});
            }
            toRoadElements_.emplace_back(*relation.seqNum, relation.other);
        }
    }
    std::sort(toRoadElements_.begin(), toRoadElements_.end());
}

} // namespace maps::wiki::validator
