#include <yandex/maps/wiki/validator/objects/cond_ds.h>
#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

#include <maps/libs/common/include/exception.h>

#include <algorithm>

namespace maps::wiki::validator {

CondDirectionSign::CondDirectionSign(
            TId id,
            const AttrMap& attributes_,
            const Relations& /* masters */,
            const Relations& slaves)
        : id_(id)
        , viaJunction_(
                extractRelation(
                        slaves, VIA_JUNCTION_ROLE, IsMandatory::Yes,
                        "bad-via-junction-relation", id))
        , fromRoadElement_(
                extractRelation(
                        slaves, FROM_RD_EL_ROLE, IsMandatory::Yes,
                        "bad-from-element-relation", id))
        , condDsElIds_(extractRelations(slaves, ASSIGNED_COND_DS_EL_ROLE))
{
    for (const auto& relation : slaves) {
        if (relation.role == TO_RD_EL_ROLE) {
            if (!relation.seqNum) {
                throw InvalidRelationsException(
                    "bad-cond-relation", id,
                    {relation.other});
            }
            toRoadElements_.emplace_back(*relation.seqNum, relation.other);
        }
    }
    std::sort(toRoadElements_.begin(), toRoadElements_.end());

    try {
        direction_ = common::laneDirectionFromString(extractAttrBySuffix<std::string>(
                        attributes_, DIRECTION_ATTR_SUFFIX, IsMandatory::Yes,
                        "bad-cond-ds-direction", id));
    } catch (common::LanesException& ex) {
        throw ObjectLoadingException("bad-cond-ds-direction", id);
    }
}

} // namespace maps::wiki::validator
