#include <yandex/maps/wiki/validator/objects/cond_ds_el.h>
#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

#include <maps/libs/common/include/exception.h>

#include <algorithm>

namespace maps::wiki::validator {

CondDirectionSignElement::CondDirectionSignElement(
            TId id,
            const AttrMap& attributes_,
            const Relations& masters,
            const Relations& /* slaves */)
        : id_(id)
        , name_(
            extractAttrBySuffix<std::string>(
                attributes_, NAME_ATTR_SUFFIX, IsMandatory::No, {}, id_))
        , lang_(
            extractAttrBySuffix<std::string>(
                attributes_, LANG_ATTR_SUFFIX, IsMandatory::No, {}, id_))
        , type_(
            extractAttrBySuffix<std::string>(
                attributes_, TYPE_ATTR_SUFFIX, IsMandatory::Yes, "bad-cond-ds-el-type", id_))
        , color_(
            extractAttrBySuffix<std::string>(
                attributes_, COLOR_ATTR_SUFFIX, IsMandatory::No, {}, id_))
        , icon_(
            extractAttrBySuffix<std::string>(
                attributes_, ICON_ATTR_SUFFIX, IsMandatory::No, {}, id_))
        , order_(
            extractAttrBySuffix<int>(
                attributes_, ORDER_ATTR_SUFFIX, IsMandatory::Yes, "bad-cond-ds-el-order", id_))
        , newLine_(
            extractAttrBySuffix<bool>(
                attributes_, NEW_LINE_ATTR_SUFFIX, IsMandatory::No, {}, id_))
        , parent_(
                extractRelation(
                        masters, ASSIGNED_COND_DS_EL_ROLE, IsMandatory::Yes,
                        "bad-assigned-cond-ds-el-relation", id))
{
}

} // namespace maps::wiki::validator
