#include <yandex/maps/wiki/validator/objects/cond_toll.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

CondToll::CondToll(
            TId id,
            const AttrMap& /* attributes */,
            const Relations& /* masters */,
            const Relations& slaves)
        : id_(id)
        , viaJunction_(
                extractRelation(
                        slaves, VIA_JUNCTION_ROLE, IsMandatory::Yes,
                        "bad-via-junction-relation", id))
        , fromRoadElement_(
                extractRelation(
                        slaves, FROM_RD_EL_ROLE, IsMandatory::Yes,
                        "bad-from-element-relation", id))
{
}

} // namespace maps::wiki::validator
