#include <yandex/maps/wiki/validator/objects/condition_lane.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

ConditionLane::ConditionLane(
            TId id,
            const AttrMap& attributes,
            const Relations& /* masters */,
            const Relations& slaves)
        : id_(id)
        , laneMin_(
                extractAttrBySuffix<int>(
                        attributes, LANE_MIN_ATTR_SUFFIX, IsMandatory::Yes,
                        "bad-lane-min", id))
        , laneMax_(
                extractAttrBySuffix<int>(
                        attributes, LANE_MAX_ATTR_SUFFIX, IsMandatory::Yes,
                        "bad-lane-max", id))
        , accessId_(
                extractAttrBySuffix<common::AccessId>(
                        attributes, ACCESS_ID_ATTR_SUFFIX, IsMandatory::Yes,
                        "bad-access-id", id))
        , viaJunction_(
                extractRelation(
                        slaves, VIA_JUNCTION_ROLE, IsMandatory::Yes,
                        "bad-via-junction-relation", id))
        , fromRoadElement_(
                extractRelation(
                        slaves, FROM_RD_EL_ROLE, IsMandatory::Yes,
                        "bad-from-element-relation", id))
        , schedules_(extractRelations(slaves, APPLIED_TO_ROLE))
{
    requireOnObjectLoad(common::isValid(accessId_), "bad-access-id", id);

    try {
        lane_ = common::laneDirectionFromString(extractAttrBySuffix<std::string>(
                        attributes, LANE_ATTR_SUFFIX, IsMandatory::Yes,
                        "bad-cond-lane", id));
    } catch (common::LanesException& ex) {
        throw ObjectLoadingException("bad-lane-value", id);
    }

    for (const auto& relation : slaves) {
        if (relation.role == TO_RD_EL_ROLE) {
            if (!relation.seqNum) {
                throw InvalidRelationsException(
                    "bad-cond-relation", id,
                    {relation.other});
            }
            toRoadElements_.emplace_back(*relation.seqNum, relation.other);
        }
    }
    std::sort(toRoadElements_.begin(), toRoadElements_.end());
}

} // namespace maps::wiki::validator
