#include <yandex/maps/wiki/validator/objects/edge.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

Edge::Edge(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , fromZlevel_(
            extractAttrBySuffix<int>(
                    attributes, F_ZLEV_ATTR_SUFFIX, IsMandatory::No,
                    "bad-f-zlev", id_))
    , toZlevel_(
            extractAttrBySuffix<int>(
                    attributes, T_ZLEV_ATTR_SUFFIX, IsMandatory::No,
                    "bad-t-zlev", id_))
    , startJunction_(
            extractRelation(
                    slaves, START_JUNCTION_ROLE, IsMandatory::Yes,
                    "bad-start-junction-relation", id_))
    , endJunction_(
            extractRelation(
                    slaves, END_JUNCTION_ROLE, IsMandatory::Yes,
                    "bad-end-junction-relation", id_))
    , parents_(extractRelations(masters, {PART_ROLE, LN_PART_ROLE, METRO_PART_ROLE}))
{
    requireOnObjectLoad(geom_.pointsNumber() >= 2, MESSAGE_BAD_GEOMETRY, id_);
}

} // namespace maps::wiki::validator
