#include <yandex/maps/wiki/validator/objects/face.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

namespace {
const std::string MESSAGE_BAD_IS_INTERIOR = "bad-is-interior";
} // namespace

Face::Face(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , parent_(
            extractRelation(
                    masters, {PART_ROLE, FC_PART_ROLE}, IsMandatory::No,
                    MESSAGE_BAD_PARENT_RELATION, id))
    , edges_(extractRelations(slaves, PART_ROLE))
    , isInterior_(
            extractAttrBySuffix<bool>(
                    attributes, IS_INTERIOR_ATTR_SUFFIX, IsMandatory::Yes,
                    MESSAGE_BAD_IS_INTERIOR, id))
{ }

} // namespace maps::wiki::validator
