#include <yandex/maps/wiki/validator/objects/flat_range.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>
#include <yandex/maps/wiki/validator/categories.h>

namespace maps::wiki::validator {

FlatRange::FlatRange(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& /* slaves */)
    : id_(id)
    , flats_(extractAttrBySuffix<std::string>(
        attributes, FLAT_RANGE_FLATS_ATTR_SUFFIX, IsMandatory::Yes, "bad-flats", id))
    , levels_(extractOptionalAttrBySuffix<std::string>(
        attributes, FLAT_RANGE_LEVELS_ATTR_SUFFIX, "bad-levels", id))
{
    for (const auto& masterRel : masters) {
        if (masterRel.role == FLAT_RANGE_ASSIGNED_ROLE) {
            parentId_ = masterRel.other;
        }
    }
}

} // namespace maps::wiki::validator
