#include <yandex/maps/wiki/validator/objects/indoor_level.h>
#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

IndoorLevel::IndoorLevel(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , parent_(
        extractRelation(
            masters, {ASSIGNED_ROLE}, IsMandatory::No,
            MESSAGE_BAD_PARENT_RELATION, id))
    , names_(extractNameRelations(slaves))
    , isDefault_(
        extractAttrBySuffix<bool>(
            attributes, DEFAULT_ATTR_SUFFIX, IsMandatory::No, "indoor-level-bad-default", id))
    , isUnderground_(
        extractAttrBySuffix<bool>(
            attributes, UNDERGROUND_ATTR_SUFFIX, IsMandatory::No, "indoor-level-bad-underground", id))
    , order_(
        extractAttrBySuffix<int>(
            attributes, ORDER_ATTR_SUFFIX, IsMandatory::Yes, "indoor-level-bad-order", id))
    , universal_(
        extractAttrBySuffix<std::string>(
            attributes, UNIVERSAL_ATTR_SUFFIX, IsMandatory::Yes, "indoor-level-bad-universal", id))
{ }

} // namespace maps::wiki::validator
