#include <yandex/maps/wiki/validator/objects/indoor_plan.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

IndoorPlan::IndoorPlan(
        TId id,
        PointFeature::TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : PointFeature(id, geom, attributes, masters, slaves)
    , isNotOperating_(
        extractAttrBySuffix<bool>(
            attributes, NOT_OPERATING_ATTR_SUFFIX, IsMandatory::No,
            "bad-not_operating", id))
{
    for (const auto& masterRel : masters) {
        if (masterRel.role == INDOOR_PLAN_ASSIGNED_ROLE) {
            parentIds_.insert(masterRel.other);
        }
    }
}

} // namespace maps::wiki::validator
