#include <yandex/maps/wiki/validator/objects/linear_feature.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

LinearFeature::LinearFeature(
        TId id,
        const AttrMap& attributes,
        const Relations& /* masters */,
        const Relations& slaves)
    : id_(id)
    , featureType_(extractFeatureType(attributes, id))
    , childFeatures_(extractRelations(slaves, ASSIGNED_ROLE))
    , elements_(extractRelations(slaves, { PART_ROLE, LN_PART_ROLE }))
    , names_(extractNameRelations(slaves))
{ }

} // namespace maps::wiki::validator
