#include <yandex/maps/wiki/validator/objects/name.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

namespace {
const std::string MESSAGE_BAD_NAME_RELATION = "bad-name-relation";
const std::string MESSAGE_BAD_NAME = "bad-name";
} // namespace

Name::Name(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& /* slaves */)
    : id_(id)
    , parentId_(0)
    , isLocal_(true)
{
    if (masters.empty()) {
        // unbound object, do not check
        return;
    }

    parentId_ = masters.front().other;
    auto nameRelTypeIt = ROLE_TO_NAME_RELATION_TYPE.find(masters.front().role);
    requireOnObjectLoad(
            masters.size() == 1 && nameRelTypeIt != std::end(ROLE_TO_NAME_RELATION_TYPE),
            MESSAGE_BAD_NAME_RELATION, parentId_);
    type_ = nameRelTypeIt->second;

    name_ = extractAttrBySuffix<std::string>(
        attributes, NAME_ATTR_SUFFIX, IsMandatory::No, MESSAGE_BAD_NAME, parentId_);
    lang_ = extractAttrBySuffix<std::string>(
        attributes, LANG_ATTR_SUFFIX, IsMandatory::Yes, MESSAGE_BAD_NAME, parentId_);
    isLocal_ = extractAttrBySuffix<bool>(
        attributes, IS_LOCAL_ATTR_SUFFIX, IsMandatory::Yes, MESSAGE_BAD_NAME, parentId_);
}

} // namespace maps::wiki::validator
