#include <yandex/maps/wiki/validator/objects/parking_controlled_zone.h>

#include "object_init_helpers.h"

namespace maps::wiki::validator {

ParkingControlledZone::ParkingControlledZone(
        TId id,
        TGeom geom,
        const AttrMap&  /* attributes */,
        const Relations&  /* masters */,
        const Relations& slaves):
    id_(id),
    geom_(std::move(geom)),
    parkingLots_(extractRelations(slaves, "parking_lot_assigned")),
    linearParkingLots_(extractRelations(slaves, "parking_lot_linear_assigned"))
{}

} // namespace maps::wiki::validator
