#include <yandex/maps/wiki/validator/objects/parking_lot.h>

#include "object_init_helpers.h"

namespace maps::wiki::validator {

ParkingLot::ParkingLot(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& /* masters */,
        const Relations& slaves):
    id_(id),
    geom_(std::move(geom)),
    names_(extractNameRelations(slaves)),
    isToll_(extractOptionalAttrBySuffix<bool>(attributes, ":toll", "bad-toll-attribute", id_)),
    isResidential_(extractOptionalAttrBySuffix<bool>(attributes, ":residental", "bad-residential-attribute", id_)),
    isParkAndRide_(extractOptionalAttrBySuffix<bool>(attributes, ":parkandride", "bad-parkandride-attribute", id_)),
    isBld_(extractOptionalAttrBySuffix<bool>(attributes, ":bld", "bad-bld-attribute", id_))
{}

} // namespace maps::wiki::validator
