#include <yandex/maps/wiki/validator/objects/poi_entrance.h>
#include "object_init_helpers.h"

namespace maps::wiki::validator {

PoiEntrance::PoiEntrance(
        TId id,
        TGeom geom,
        const AttrMap& /* attributes */,
        const Relations& /* masters */,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , names_(extractNameRelations(slaves))
    , flatRanges_(extractRelations(slaves, FLAT_RANGE_ASSIGNED_ROLE))
{}

} // namespace maps::wiki::validator
