#include <yandex/maps/wiki/validator/objects/point_feature.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

PointFeature::PointFeature(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , featureType_(extractFeatureType(attributes, id))
    , geom_(std::move(geom))
    , parent_(
            extractRelation(
                    masters, ASSIGNED_ROLE, IsMandatory::No,
                    MESSAGE_BAD_PARENT_RELATION, id))
    , childFeatures_(extractRelations(slaves, ASSIGNED_ROLE))
    , names_(extractNameRelations(slaves))
    , importSourceId_(extractImportSourceId(attributes, id))
    , importSource_(extractImportSource(attributes, id))
{ }

} // namespace maps::wiki::validator
