#include <yandex/maps/wiki/validator/objects/polygon_feature.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

PolygonFeature::PolygonFeature(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , featureType_(extractFeatureType(attributes, id))
    , geom_(std::move(geom))
    , parent_(
        extractRelation(
            masters,
            {URBAN_AREAL_ASSIGNED_ROLE, ASSIGNED_ROLE, ASSIGNED_INDOOR_AREA},
            IsMandatory::No,
            MESSAGE_BAD_PARENT_RELATION, id))
    , names_(extractNameRelations(slaves))
{ }

} // namespace maps::wiki::validator
