#include <yandex/maps/wiki/validator/objects/polyline_feature.h>

#include "object_init_helpers.h"

namespace maps::wiki::validator {

PolylineFeature::PolylineFeature(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& /* slaves */):
    id_(id),
    geom_(std::move(geom)),
    featureType_(extractFeatureType(attributes, id_)),
    parent_(
        extractRelation(
            masters,
            {
                ASSIGNED_INDOOR_RADIOMAP_CAPTURER_PATH_ROLE,
                PARKING_LOT_LINEAR_ASSIGNED_ROLE,
            },
            IsMandatory::No,
            MESSAGE_BAD_PARENT_RELATION,
            id_))
{}

} // namespace maps::wiki::validator
