#include <yandex/maps/wiki/validator/objects/region.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

Region::Region(
        TId id,
        TGeom geom,
        const AttrMap&,
        const Relations&,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , admUnits_(extractRelations(slaves, ASSIGNED_ROLE))
    , adNeutrals_(extractRelations(slaves, ASSIGNED_AD_NEUTURAL_ROLE))
    , names_(extractNameRelations(slaves))
{
}

} // namespace maps::wiki::validator
