#include <yandex/maps/wiki/validator/objects/road_marking_linear.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

RoadMarkingLinear::RoadMarkingLinear(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& /* slaves */)
    : id_(id)
    , geom_(std::move(geom))
    , type_(
        extractAttrBySuffix<std::string>(
            attributes, TYPE_ATTR_SUFFIX, IsMandatory::Yes,
            "bad-road-marking-linear-type", id))
    , temporary_(
        extractAttrBySuffix<bool>(
            attributes, TEMPORARY_ATTR_SUFFIX, IsMandatory::No,
            "bad-temporary-attribute", id))
    , roadSurface_(
            extractRelation(
                    masters, ASSIGNED_ROAD_MARKING_LINEAR_ROLE, IsMandatory::No,
                    MESSAGE_BAD_PARENT_RELATION, id))
{
}

} // namespace maps::wiki::validator
