#include <yandex/maps/wiki/validator/objects/road_marking_point.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

RoadMarkingPoint::RoadMarkingPoint(
        TId id,
        TGeom geom,
        const AttrMap& /* attributes */,
        const Relations& masters,
        const Relations& /* slaves */)
    : id_(id)
    , geom_(std::move(geom))
    , roadSurface_(
            extractRelation(
                    masters,
                    { ASSIGNED_ROAD_MARKING_POINT_LANE_DIRECTION_ROLE ,
                      ASSIGNED_ROAD_MARKING_POINT_SYMBOL_ROLE,
                      ASSIGNED_ROAD_MARKING_POINT_ROAD_SIGN_ROLE,
                      ASSIGNED_ROAD_MARKING_POINT_ROAD_SIGN_SPEED_LIMIT_ROLE,
                      ASSIGNED_ROAD_MARKING_POINT_TEXT_ROLE },
                    IsMandatory::No,
                    MESSAGE_BAD_PARENT_RELATION, id))
{
}

} // namespace maps::wiki::validator
