#include <yandex/maps/wiki/validator/objects/road_surface.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

RoadSurface::RoadSurface(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& /* masters */,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , type_(
        extractAttrBySuffix<std::string>(
            attributes, TYPE_ATTR_SUFFIX, IsMandatory::Yes,
            "bad-road-surface-type", id))
    , fromZlevel_(
        extractAttrBySuffix<int>(
            attributes, F_ZLEV_ATTR_SUFFIX, IsMandatory::Yes,
            "bad-f-zlev", id))
    , toZlevel_(
        extractAttrBySuffix<int>(
            attributes, T_ZLEV_ATTR_SUFFIX, IsMandatory::Yes,
            "bad-t-zlev", id))
    , polygonalMarkings_(extractRelations(slaves, ASSIGNED_ROAD_MARKING_POLYGONAL_ROLE))
    , linearMarkings_(extractRelations(slaves, ASSIGNED_ROAD_MARKING_LINEAR_ROLE))
    , pointMarkings_(extractRelations(
        slaves,
        { ASSIGNED_ROAD_MARKING_POINT_LANE_DIRECTION_ROLE ,
          ASSIGNED_ROAD_MARKING_POINT_SYMBOL_ROLE,
          ASSIGNED_ROAD_MARKING_POINT_ROAD_SIGN_ROLE,
          ASSIGNED_ROAD_MARKING_POINT_ROAD_SIGN_SPEED_LIMIT_ROLE,
          ASSIGNED_ROAD_MARKING_POINT_TEXT_ROLE }))
{
}

} // namespace maps::wiki::validator
