#include <yandex/maps/wiki/validator/objects/service_polygon.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

ServicePolygon::ServicePolygon(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& /*masters*/,
        const Relations& /*slaves*/)
    : id_(id)
    , geom_(std::move(geom))
    , name_(extractAttrBySuffix<std::string>(
            attributes, NAME_ATTR_SUFFIX, IsMandatory::No,
            {}, id))
{ }

} // namespace maps::wiki::validator
