#include <yandex/maps/wiki/validator/objects/traffic_light.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

TrafficLight::TrafficLight(
            TId id,
            const AttrMap& /* attributes */,
            const Relations& /* masters */,
            const Relations& slaves)
        : id_(id)
        , placedAtJunction_(
                extractRelation(
                    slaves, PLACED_AT_JUNCTION_ROLE, IsMandatory::Yes,
                    "bad-placed-at-junction-relation", id))
        , controlledRoadElements_(extractRelations(slaves, CONTROLLED_RD_EL_ROLE))
{
    requireOnObjectLoad(
        !controlledRoadElements_.empty(),
        "bad-controlled-relation", id);
}

} // namespace maps::wiki::validator
