#include <yandex/maps/wiki/validator/objects/transport_element.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

TransportElement::TransportElement(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , fromZlevel_(
            extractAttrBySuffix<int>(
                    attributes, F_ZLEV_ATTR_SUFFIX, IsMandatory::No,
                    "bad-f-zlev", id))
    , toZlevel_(
            extractAttrBySuffix<int>(
                    attributes, T_ZLEV_ATTR_SUFFIX, IsMandatory::No,
                    "bad-t-zlev", id))
    , startJunction_(
            extractRelation(
                    slaves, START_JUNCTION_ROLE, IsMandatory::Yes,
                    "bad-start-junction-relation", id))
    , endJunction_(
            extractRelation(
                    slaves, END_JUNCTION_ROLE, IsMandatory::Yes,
                    "bad-end-junction-relation", id))
    , lines_(extractRelations(masters, {PART_ROLE}))
    , threads_(extractRelations(masters, {METRO_PART_ROLE}))
{
    requireOnObjectLoad(geom_.pointsNumber() >= 2, MESSAGE_BAD_GEOMETRY, id);
}

} // namespace maps::wiki::validator
