#include <yandex/maps/wiki/validator/objects/transport_line.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

TransportLine::TransportLine(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , transportOperator_(
        extractRelation(
            masters,
            {
                ASSIGNED_ROLE,
                ASSIGNED_METRO_ROLE,
                ASSIGNED_WATERWAY_ROLE,
                ASSIGNED_TRAM_ROLE,
                ASSIGNED_BUS_ROLE,
            },
            IsMandatory::No, MESSAGE_BAD_PARENT_RELATION, id))
    , featureType_(extractFeatureType(attributes, id))
    , stations_(extractRelations(slaves, ASSIGNED_ROLE))
    , elements_(extractRelations(slaves, PART_ROLE))
    , threads_(extractRelations(slaves, ASSIGNED_THREAD_ROLE))
    , names_(extractNameRelations(slaves))
    , importSourceId_(extractImportSourceId(attributes, id))
    , importSource_(extractImportSource(attributes, id))
{ }


} // namespace maps::wiki::validator
