#include <yandex/maps/wiki/validator/objects/transport_metro_exit.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

TransportMetroExit::TransportMetroExit(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , station_(extractRelation(
        masters, ASSIGNED_ROLE,
        IsMandatory::No, MESSAGE_BAD_PARENT_RELATION, id))
    , names_(extractNameRelations(slaves))
    , passageways_(extractRelations(masters, EXIT_ROLE))
    , importSourceId_(extractImportSourceId(attributes, id))
    , importSource_(extractImportSource(attributes, id))
{
}

} // namespace maps::wiki::validator
