#include <yandex/maps/wiki/validator/objects/transport_metro_station.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

TransportMetroStation::TransportMetroStation(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , stops_(extractRelations(slaves, ASSIGNED_THREAD_STOP_ROLE))
    , exits_(extractRelations(slaves, ASSIGNED_ROLE))
    , line_(extractRelation(
        masters, ASSIGNED_ROLE,
        IsMandatory::Yes, MESSAGE_BAD_PARENT_RELATION, id))
    , names_(extractNameRelations(slaves))
    , importSourceId_(extractImportSourceId(attributes, id))
    , importSource_(extractImportSource(attributes, id))
    , geobaseId_(extractGeobaseId(attributes, id))
{
}

} // namespace maps::wiki::validator
