#include <yandex/maps/wiki/validator/objects/transport_operator.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

TransportOperator::TransportOperator(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& /* masters */,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , names_(extractNameRelations(slaves))
    , skipValidation_(
        extractAttrBySuffix<bool>(
            attributes, SKIP_VALIDATION_ATTR_SUFFIX, IsMandatory::Yes,
            "bad-skip-validation", id))
{ }

} // namespace validator
