#include <yandex/maps/wiki/validator/objects/transport_passageway.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

namespace {
const std::string MESSAGE_BAD_TIME = "bad-time";
const std::string MESSAGE_BAD_ONEWAY = "bad-oneway";
} // namespace

TransportPassageway::TransportPassageway(
        TId id,
        const AttrMap& attributes,
        const Relations& /* masters */,
        const Relations& slaves)
    : id_(id)
    , station_(extractRelation(slaves, STATION_ROLE,
        IsMandatory::Yes, "bad-station-relation", id))
    , exit_(extractRelation(slaves, EXIT_ROLE,
        IsMandatory::Yes, "bad-exit-relation", id))
    , transitionTime_(-1) // zero is valid for rapid_tram
    , oneway_(Oneway::Both)
{
    auto iterTime =
        findAttrBySuffix(attributes, TIME_ATTR_SUFFIX, MESSAGE_BAD_TIME, id);
    if (iterTime != attributes.end()) {
        transitionTime_ = castAttr<TSeconds>(
            attributes, iterTime, IsMandatory::No, MESSAGE_BAD_TIME, id);
    }
    auto iterOneway =
        findAttrBySuffix(attributes, ONEWAY_ATTR_SUFFIX, MESSAGE_BAD_ONEWAY, id);
    if (iterOneway != attributes.end()) {
        const auto& value = iterOneway->second;
        if (value == "B") {
            oneway_ = Oneway::Both;
        } else if (value == "F") {
            oneway_ = Oneway::From;
        } else if (value == "T") {
            oneway_ = Oneway::To;
        } else {
            requireOnObjectLoad(false, MESSAGE_BAD_ONEWAY, id);
        }
    }
}

} // namespace maps::wiki::validator
