#include <yandex/maps/wiki/validator/objects/transport_stop.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

TransportStop::TransportStop(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , geom_(std::move(geom))
    , names_(extractNameRelations(slaves))
    , routes_(extractRelations(masters, ASSIGNED_ROLE))
    , importSourceId_(extractImportSourceId(attributes, id))
    , importSource_(extractImportSource(attributes, id))
{ }

} // namespace maps::wiki::validator
