#include <yandex/maps/wiki/validator/objects/transport_thread.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

namespace {
const std::string TYPE_CIRCULAR = "circular";
} // namespace

TransportThread::TransportThread(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , line_(extractRelation(masters, ASSIGNED_THREAD_ROLE,
        IsMandatory::Yes, "bad-line-relation", id))
    , elements_(extractRelations(slaves, {
            METRO_PART_ROLE,
            BUS_PART_ROLE,
            TRAM_PART_ROLE,
            WATERWAY_PART_ROLE
        }))
    , stops_(extractRelations(slaves, PART_ROLE))
    , schedules_(extractRelations(slaves, APPLIED_TO_ROLE))
    , importSourceId_(extractImportSourceId(attributes, id))
    , importSource_(extractImportSource(attributes, id))
    , isCircular_(
        extractAttrBySuffix<std::string>(
            attributes, TYPE_ATTR_SUFFIX,
            IsMandatory::No, std::string(), id) == TYPE_CIRCULAR)
{ }

} // namespace maps::wiki::validator
