#include <yandex/maps/wiki/validator/objects/transport_thread_stop.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

TransportThreadStop::TransportThreadStop(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , previous_(extractRelation(slaves, PREVIOUS_ROLE,
        IsMandatory::No, {}, id))
    , station_(extractRelation(masters, ASSIGNED_THREAD_STOP_ROLE,
        IsMandatory::Yes, "bad-assigged_thread_stop-relation", id))
    , thread_(extractRelation(masters, PART_ROLE,
        IsMandatory::Yes, "bad-part-relation", id))
    , travelTime_(
        extractOptionalAttrBySuffix<TSeconds>(
            attributes, TRAVEL_TIME_ATTR_SUFFIX,
            "bad-travel-time", id))
    , waitTime_(
        extractOptionalAttrBySuffix<TSeconds>(
            attributes, WAIT_TIME_ATTR_SUFFIX,
            "bad-wait-time", id))
{
}

} // namespace maps::wiki::validator
