#include <yandex/maps/wiki/validator/objects/transport_transition.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

TransportTransition::TransportTransition(
        TId id,
        const AttrMap& attributes,
        const Relations& /*masters*/,
        const Relations& slaves)
    : id_(id)
    , stationA_(
        extractRelation(slaves, STATION_A_ROLE,
            IsMandatory::Yes, "bad-station-relation", id))
    , stationB_(
        extractRelation(slaves, STATION_B_ROLE,
            IsMandatory::Yes, "bad-station-relation", id))
    , transitionTime_(
        extractAttrBySuffix<TSeconds>(
            attributes, TIME_ATTR_SUFFIX, IsMandatory::No,
            "bad-time", id))
    , oneway_(
        extractAttrBySuffix<bool>(
            attributes, ONEWAY_ATTR_SUFFIX, IsMandatory::No,
            "bad-oneway", id))
{}

} // namespace maps::wiki::validator
