#include <yandex/maps/wiki/validator/objects/vehicle_restriction.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/exception.h>
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::validator {

VehicleRestriction::VehicleRestriction(
            TId id,
            const AttrMap& attributes,
            const Relations& /* masters */,
            const Relations& slaves)
        : id_(id)
        , accessId_(
                extractAttrBySuffix<common::AccessId>(
                        attributes, ACCESS_ID_ATTR_SUFFIX, IsMandatory::Yes,
                        "bad-access-id", id))
        , universalId_(extractAttrBySuffix<std::string>(
                        attributes, UNIVERSAL_ID_ATTR_SUFFIX, IsMandatory::Yes,
                        {}, id))
        , passId_(extractAttrBySuffix<std::string>(
                        attributes, PASS_ID_ATTR_SUFFIX, IsMandatory::No,
                        {}, id))
        , restrictsRoadElements_(extractRelations(slaves, RESTRICTS_ROLE))
        , restrictsRoadElementsFrom_(extractRelations(slaves, RESTRICTS_FROM_ROLE))
        , restrictsRoadElementsTo_(extractRelations(slaves, RESTRICTS_TO_ROLE))
        , schedules_(extractRelations(slaves, APPLIED_TO_ROLE))
        , vehicleRestrictionParameters_(readVehicleRestrictionParameters(attributes, id))
{
    requireOnObjectLoad(common::isValid(accessId_), "bad-access-id", id);
}

} // namespace maps::wiki::validator
