#include <yandex/maps/wiki/validator/result.h>

#include "task_context.h"

namespace maps {
namespace wiki {
namespace validator {

Result::Result(std::unique_ptr<TaskContext> taskContext)
    : taskContext_(std::move(taskContext))
{
    taskContext_->run();
}

Result::~Result() = default;

DBID Result::branchId() const
{
    return taskContext_->branchId();
}

DBID Result::commitId() const
{
    return taskContext_->commitId();
}

const AreaOfInterest& Result::aoi() const
{
    return taskContext_->aoi();
}

std::vector<TCheckId> Result::checkIds() const
{
    return taskContext_->checkIds();
}

MessageBuffer Result::popMessages()
{
    if (taskContext_) {
        return taskContext_->popMessages();
    }
    return {};
}

Messages Result::drainAllMessages()
{
    Messages res;
    MessageBuffer buffer;
    do {
        buffer = popMessages();
        for (auto&& message : buffer) {
            res.emplace_back(std::move(message));
        }
    } while (!buffer.empty());
    return res;
}

} // namespace validator
} // namespace wiki
} // namespace maps
