#include "exclusions_set.h"

namespace maps::wiki::validator::storage {

void ExclusionsSet::add(const std::vector<Message>& exclusions)
{
    exclusions_.insert(exclusions.cbegin(), exclusions.cend());
}

bool ExclusionsSet::contains(const Message& message) const
{
    return exclusions_.find(message) != exclusions_.end();
}

size_t ExclusionsSet::MessageHash::operator()(const Message& message) const
{
    std::hash<std::string> stringHash;
    size_t hash = stringHash(message.attributes().checkId);
    hash ^= stringHash(message.attributes().description);
    hash ^= stringHash(message.geomWkb());
    for (const RevisionID& revId : message.revisionIds()) {
        hash ^= revId.objectId();
        hash ^= revId.commitId();
    }
    return hash;
}

} // namespace maps::wiki::validator::storage
