#pragma once

#include <yandex/maps/wiki/validator/message.h>

#include <unordered_set>

namespace maps::wiki::validator::storage {

class ExclusionsSet
{
public:
    void add(const std::vector<Message>& exclusions);
    bool contains(const Message& message) const;

private:
    struct MessageHash
    {
        size_t operator()(const Message& message) const;
    };

private:
    std::unordered_set<Message, MessageHash> exclusions_;
};

} // namespace maps::wiki::validator::storage
