#pragma once

#include <yandex/maps/wiki/validator/storage/stored_message_data.h>
#include <yandex/maps/wiki/validator/storage/common.h>
#include <yandex/maps/wiki/validator/message.h>

#include <maps/libs/geolib/include/bounding_box.h>

#include <string>

namespace maps::wiki {
namespace revision {

class Snapshot;

} // namespace revision

namespace validator::storage {

struct MessageAttributesFilter;

std::string severityToPgText(Severity severity);
Severity pgTextToSeverity(const std::string& text);

std::string revisionIdsToPgText(const std::vector<RevisionID>& revIds);
std::vector<RevisionID> pgTextToRevisionIds(const std::string& textStr);

std::string whereClause(
    const MessageAttributesFilter& filter,
    const Transaction& txn);

std::string whereClause(
    const geolib3::BoundingBox& bbox);

Message::Attributes messageAttributesFromDbRow(const pqxx::row& row);

Message messageFromDbRow(const pqxx::row& row);

StoredMessageData storedMessagesFromDbRows(
    const revision::Snapshot& snapshot,
    const pqxx::result& rows);

StoredMessageData storedMessagesFromDbRows(
    const revision::Snapshot& snapshot,
    const pqxx::result::iterator& begin,
    const pqxx::result::iterator& end,
    size_t limit);

StoredMessageData storedMessagesFromDbRows(
    const revision::Snapshot& snapshot,
    const pqxx::result::reverse_iterator& rbegin,
    const pqxx::result::reverse_iterator& rend,
    size_t limit);

} // namespace validator::storage
} // namespace maps::wiki
