#pragma once

#include <string>

namespace maps::wiki::validator::storage {

const std::string MESSAGE_ATTRIBUTES_TABLE = "validation.message_attributes";
const std::string MESSAGE_CONTENT_TABLE = "validation.message_content";
const std::string TASK_MESSAGE_TABLE = "validation.task_message";
const std::string TASK_MESSAGE_STATS_TABLE = "validation.task_message_stats";
const std::string EXCLUSION_TABLE = "validation.exclusion";
const std::string EXCLUSION_VIEW_TABLE = "validation.exclusion_view";
const std::string MESSAGE_VIEW_TABLE = "validation.message_view";

const std::string MESSAGE_ATTRIBUTES_INSERT_FUNCTION
    = "validation.insert_message_attributes";
const std::string MESSAGE_CONTENT_INSERT_FUNCTION
    = "validation.insert_message_content";
const std::string TASK_MESSAGE_STATS_UPDATE_FUNCTION
    = "validation.update_task_message_stats";

const std::string TASK_ID_COLUMN_NAME = "task_id";

const std::string ATTRIBUTES_ID_COLUMN_NAME = "attributes_id";
const std::string CONTENT_ID_COLUMN_NAME = "content_id";

const std::string MESSAGE_ID_COLUMNS =
    ATTRIBUTES_ID_COLUMN_NAME
    + "," + CONTENT_ID_COLUMN_NAME;

const std::string JOIN_MESSAGE_ATTRIBUTES_TABLE =
    " JOIN " + MESSAGE_ATTRIBUTES_TABLE
    + " USING (" + ATTRIBUTES_ID_COLUMN_NAME + ")";
const std::string JOIN_MESSAGE_SUBSTANCE_TABLES =
    JOIN_MESSAGE_ATTRIBUTES_TABLE
    + " JOIN " + MESSAGE_CONTENT_TABLE
    + " USING (" + CONTENT_ID_COLUMN_NAME + ")";

const std::string SEVERITY_COLUMN_NAME = "severity";
const std::string CHECK_ID_COLUMN_NAME = "check_id";
const std::string DESCRIPTION_COLUMN_NAME = "description";
const std::string IMPORTANT_REGION_COLUMN_NAME = "important_region";

const std::string MESSAGE_ATTRIBUTES_COLUMNS =
    SEVERITY_COLUMN_NAME
    + "," + DESCRIPTION_COLUMN_NAME
    + "," + CHECK_ID_COLUMN_NAME
    + "," + IMPORTANT_REGION_COLUMN_NAME;

const std::string GEOMETRY_COLUMN_NAME = "the_geom";
const std::string REVISION_IDS_COLUMN_NAME = "revision_ids";

const std::string MESSAGE_SUBSTANCE_COLUMNS =
    MESSAGE_ATTRIBUTES_COLUMNS
    + ",ST_AsBinary(" + GEOMETRY_COLUMN_NAME + ") AS " + GEOMETRY_COLUMN_NAME
    + "," + REVISION_IDS_COLUMN_NAME;

const std::string CREATED_COLUMN_NAME = "created";
const std::string CREATED_BY_COLUMN_NAME = "created_by";

const std::string EXCLUSION_INFO_COLUMNS =
    CREATED_COLUMN_NAME
    + "," + CREATED_BY_COLUMN_NAME;

const std::string VIEWED_BY_COLUMN_NAME = "viewed_by";
const std::string VIEWED_BY_ARR_COLUMN_NAME = "viewed_by_arr";
const std::string IS_VIEWED_COLUMN_NAME = "is_viewed";

const std::string STORED_MESSAGE_COLUMNS =
    MESSAGE_ID_COLUMNS
    + "," + MESSAGE_SUBSTANCE_COLUMNS
    + "," + EXCLUSION_INFO_COLUMNS;

const std::string COUNT_COLUMN_NAME = "count";

const std::string LESS = "<";
const std::string GREATER = ">";

const std::string MESSAGES_ORDER =
    " ORDER BY " + CREATED_COLUMN_NAME + " DESC ";
const std::string MESSAGES_ORDER_REVERT =
    " ORDER BY " + CREATED_COLUMN_NAME + " ASC ";

} // namespace maps::wiki::validator::storage
