#include <yandex/maps/wiki/validator/storage/stored_message_data.h>

namespace maps::wiki::validator::storage {

namespace {

const char MESSAGE_ID_SEP = '-';

} // namespace

// ---------------------- MessageId ------------------------

std::istream& operator>>(std::istream& is, MessageId& messageId)
{
    uint32_t attributesId;
    uint64_t contentId;
    char sep;

    if (!(is >> attributesId) || !(is >> sep)) {
        is.setstate(std::ios_base::failbit);
        return is;
    }

    if (sep != MESSAGE_ID_SEP) {
        is.setstate(std::ios_base::failbit);
        return is;
    }

    if (!(is >> contentId)) {
        is.setstate(std::ios_base::failbit);
        return is;
    }

    messageId = MessageId(attributesId, contentId);
    return is;
}

std::ostream& operator<<(std::ostream& os, const MessageId& messageId)
{
    os << messageId.attributesId() << MESSAGE_ID_SEP << messageId.contentId();
    return os;
}

MessageId::MessageId(uint32_t attributesId, uint64_t contentId)
    : attributesId_(attributesId), contentId_(contentId)
{ }

// ---------------------- StoredMessageDatum ------------------------

StoredMessageDatum::StoredMessageDatum(
        MessageId id,
        bool isActive,
        boost::optional<ExclusionInfo> exclusionInfo,
        Message message,
        bool isViewed)
    : id_(id)
    , isActive_(isActive)
    , exclusionInfo_(std::move(exclusionInfo))
    , message_(std::move(message))
    , isViewed_(isViewed)
{ }

} // namespace maps::wiki::validator::storage
