#pragma once

#include <yandex/maps/wiki/validator/check_context.h>

#include <list>
#include <mutex>
#include <unordered_map>

namespace maps::wiki::validator {

using MessageBuffer = std::list<Message>;
using MessageKeyToPtr = std::unordered_map<MessageKey, Message*>;

struct CheckMessages
{
    MessageBuffer messages;
    MessageKeyToPtr messageKeyToPtr;
};

class TaskMessages
{
public:
    void addMessage(
        Message message,
        TCheckId checkId,
        MessageKeyGenerator keyGenerator,
        MessageComparator messageComparator);

    void addBaseCheckMessages(MessageBuffer buffer);

    MessageBuffer popMessages();

private:
    mutable std::mutex mutex_;
    std::unordered_map<TCheckId, CheckMessages> messagesByCheck_;
};

} // namespace maps::wiki::validator
