#include <yandex/maps/wiki/validator/validator_config.h>

#include "loader/category_revisions_loader.h"

namespace fs = boost::filesystem;

namespace maps {
namespace wiki {
namespace validator {

std::ostream& operator<<(std::ostream& stream, LoaderType loaderType)
{
    switch (loaderType) {
    case LoaderType::LoadAll:
        stream << "all objects";
        break;
    case LoaderType::LoadFromAoi:
        stream << "aoi";
        break;
    case LoaderType::LoadBySelectedObjects:
        stream << "selected objects";
        break;
    }
    return stream;
}

ValidatorConfig::ValidatorConfig()
    : editorConfig_()
    , revisionIdsLoaders_(std::make_unique<RevisionIdsLoadersStore>(editorConfig_))
{
}

ValidatorConfig::ValidatorConfig(const fs::path& editorConfigPath)
    : editorConfig_(editorConfigPath.string())
    , revisionIdsLoaders_(std::make_unique<RevisionIdsLoadersStore>(editorConfig_))
{
}

ValidatorConfig::~ValidatorConfig() = default;

const RevisionIdsLoaderFunc& ValidatorConfig::categoryRevisionIdsLoader(
    const TCategoryId& categoryId,
    LoaderType loaderType) const
{
    ASSERT(revisionIdsLoaders_);
    return revisionIdsLoaders_->loader(categoryId, loaderType).load;
}

const std::set<TCategoryId>& ValidatorConfig::loaderDependencies(
    const TCategoryId& categoryId,
    LoaderType loaderType) const
{
    ASSERT(revisionIdsLoaders_);
    return revisionIdsLoaders_->loader(categoryId, loaderType).dependencies;
}

} // namespace validator
} // namespace wiki
} // namespace maps
