#include <maps/wikimap/mapspro/libs/yt_stubs/include/table_reader.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::yt_stubs {

NodeReaderImplStub::NodeReaderImplStub(std::vector<NYT::TNode> rows) :
    rows_(std::move(rows))
{
    iter_ = rows_.begin();
}

bool NodeReaderImplStub::IsValid() const
{
    return iter_ != rows_.end();
}

void NodeReaderImplStub::Next()
{
    ASSERT(IsValid());
    ++iter_;
}

const NYT::TNode& NodeReaderImplStub::GetRow() const
{
    ASSERT(IsValid());
    return *iter_;
}

ui32 NodeReaderImplStub::GetTableIndex() const
{
    return 0;
}

ui32 NodeReaderImplStub::GetRangeIndex() const
{
    return 0;
}

ui64 NodeReaderImplStub::GetRowIndex() const
{
    return 0;
}

void NodeReaderImplStub::NextKey()
{
}

void NodeReaderImplStub::MoveRow(NYT::TNode* row)
{
    Y_UNUSED(row);
}


TIntrusivePtr<NYT::TTableReader<NYT::TNode>>
createTableReaderStub(TIntrusivePtr<NodeReaderImplStub> readerImpl)
{
    return new NYT::TTableReader<NYT::TNode>(readerImpl);
}

} // namespace maps::wiki::yt_stubs
