#include <maps/wikimap/mapspro/libs/yt_stubs/include/table_writer.h>

namespace maps::wiki::yt_stubs {

namespace {

class OutputStreamStub : public IOutputStream
{
protected:
    void DoWrite(const void* buf, size_t len) override
    {
        Y_UNUSED(buf);
        Y_UNUSED(len);
    }
};

} // unnamed namespace


NodeWriterImplStub::NodeWriterImplStub() {}

void NodeWriterImplStub::AddRow(const NYT::TNode& row, size_t tableIndex)
{
    Y_UNUSED(tableIndex);
    rows_.push_back(row);
}

void NodeWriterImplStub::AddRow(NYT::TNode&& row, size_t tableIndex)
{
    Y_UNUSED(tableIndex);
    rows_.push_back(std::move(row));
}

size_t NodeWriterImplStub::GetTableCount() const
{
    return 1;
}

void NodeWriterImplStub::FinishTable(size_t) {}

const std::vector<NYT::TNode>& NodeWriterImplStub::getOutputRows() const
{
    return rows_;
}


TIntrusivePtr<NYT::TTableWriter<NYT::TNode>>
createTableWriterStub(TIntrusivePtr<NodeWriterImplStub> writerImpl)
{
    return new NYT::TTableWriter<NYT::TNode>(writerImpl);
}

} // namespace maps::wiki::yt_stubs
