#pragma once

#include "table_reader.h"
#include "table_writer.h"

namespace maps::wiki::yt_stubs {

template<typename Operation>
std::vector<NYT::TNode>
executeOperation(
    Operation& op,
    const std::vector<NYT::TNode> &inputRows)
{
    auto readerImpl = MakeIntrusive<NodeReaderImplStub>(inputRows);
    auto writerImpl = MakeIntrusive<NodeWriterImplStub>();

    auto reader = createTableReaderStub(readerImpl);
    auto writer = createTableWriterStub(writerImpl);

    op.Do(reader.Get(), writer.Get());

    return writerImpl->getOutputRows();
}

} // namespace maps::wiki::yt_stubs
