#pragma once

#include <mapreduce/yt/interface/client.h>
#include <vector>

namespace maps::wiki::yt_stubs {

class NodeReaderImplStub : public NYT::INodeReaderImpl
{
public:
    bool IsValid() const override;
    void Next() override;
    const NYT::TNode& GetRow() const override;
    ui32 GetTableIndex() const override;
    ui32 GetRangeIndex() const override;
    ui64 GetRowIndex() const override;
    void NextKey() override;
    void MoveRow(NYT::TNode* row) override;

public:
    NodeReaderImplStub(std::vector<NYT::TNode> rows);

private:
    std::vector<NYT::TNode> rows_;
    std::vector<NYT::TNode>::const_iterator iter_;
};

// Factory
//
TIntrusivePtr<NYT::TTableReader<NYT::TNode>>
createTableReaderStub(TIntrusivePtr<NodeReaderImplStub> readerImpl);

} // namespace maps::wiki::yt_stubs
